/*
 * Decompiled with CFR 0.152.
 */
package invtweaks;

import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class InvTweaksItemTreeCategory {
    private static final Logger log = InvTweaks.log;
    private final Map items = new HashMap();
    private final Vector matchingItems = new Vector();
    private final Vector subCategories = new Vector();
    private String name;
    private int order = -1;

    public InvTweaksItemTreeCategory(String string) {
        this.name = string != null ? string.toLowerCase() : null;
    }

    public boolean contains(InvTweaksItemTreeItem invTweaksItemTreeItem) {
        List list = (List)this.items.get(invTweaksItemTreeItem.getId());
        if (list != null) {
            for (Object object : list) {
                if (!((InvTweaksItemTreeItem)object).equals(invTweaksItemTreeItem)) continue;
                return true;
            }
        }
        for (Object object : this.subCategories) {
            if (!((InvTweaksItemTreeCategory)object).contains(invTweaksItemTreeItem)) continue;
            return true;
        }
        return false;
    }

    public void addCategory(InvTweaksItemTreeCategory invTweaksItemTreeCategory) {
        this.subCategories.add(invTweaksItemTreeCategory);
    }

    public void addItem(InvTweaksItemTreeItem invTweaksItemTreeItem) {
        if (this.items.get(invTweaksItemTreeItem.getId()) == null) {
            ArrayList<InvTweaksItemTreeItem> arrayList = new ArrayList<InvTweaksItemTreeItem>();
            arrayList.add(invTweaksItemTreeItem);
            this.items.put(invTweaksItemTreeItem.getId(), arrayList);
        } else {
            ((List)this.items.get(invTweaksItemTreeItem.getId())).add(invTweaksItemTreeItem);
        }
        this.matchingItems.add(invTweaksItemTreeItem.getName());
        if (this.order == -1 || this.order > invTweaksItemTreeItem.getOrder()) {
            this.order = invTweaksItemTreeItem.getOrder();
        }
    }

    public int getCategoryOrder() {
        if (this.order != -1) {
            return this.order;
        }
        for (InvTweaksItemTreeCategory invTweaksItemTreeCategory : this.subCategories) {
            int n = invTweaksItemTreeCategory.getCategoryOrder();
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    public int findCategoryOrder(String string) {
        if (string.equals(this.name)) {
            return this.getCategoryOrder();
        }
        for (InvTweaksItemTreeCategory invTweaksItemTreeCategory : this.subCategories) {
            int n = invTweaksItemTreeCategory.findCategoryOrder(string);
            if (n == -1) continue;
            return n;
        }
        return -1;
    }

    public int findKeywordDepth(String string) {
        if (this.name.equals(string)) {
            return 0;
        }
        if (this.matchingItems.contains(string)) {
            return 1;
        }
        for (InvTweaksItemTreeCategory invTweaksItemTreeCategory : this.subCategories) {
            int n = invTweaksItemTreeCategory.findKeywordDepth(string);
            if (n == -1) continue;
            return n + 1;
        }
        return -1;
    }

    public Collection getSubCategories() {
        return this.subCategories;
    }

    public Collection getItems() {
        return this.items.values();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " (" + this.subCategories.size() + " cats, " + this.items.size() + " items)";
    }
}

